/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.setting.settings;

import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.framework.msdf.Font;
import Krasnodar.rockstarnew.framework.msdf.Fonts;
import Krasnodar.rockstarnew.framework.objects.BorderRadius;
import Krasnodar.rockstarnew.systems.modules.Module;
import Krasnodar.rockstarnew.systems.setting.SettingsContainer;
import Krasnodar.rockstarnew.systems.setting.impl.AbstractSetting;
import Krasnodar.rockstarnew.utility.animation.base.Animation;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.render.DrawUtility;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.BooleanSupplier;

public class PositionSetting
extends AbstractSetting {
    private float x;
    private float y;
    private final float minX;
    private final float maxX;
    private final float minY;
    private final float maxY;
    private final float defaultX;
    private final float defaultY;
    private boolean dragging = false;
    private final Animation animatedX = new Animation(100L, Easing.CUBIC_OUT);
    private final Animation animatedY = new Animation(100L, Easing.CUBIC_OUT);
    private final Animation hoverAnimation = new Animation(200L, Easing.CUBIC_OUT);
    private final Animation dragAnimation = new Animation(150L, Easing.CUBIC_OUT);

    public PositionSetting(Module module, String name, float defaultX, float defaultY) {
        this(module, name, defaultX, defaultY, -2.5f, 2.5f, -2.0f, 2.0f);
    }

    public PositionSetting(Module module, String name, float defaultX, float defaultY, float minX, float maxX, float minY, float maxY) {
        super(module, name);
        this.x = defaultX;
        this.y = defaultY;
        this.defaultX = defaultX;
        this.defaultY = defaultY;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.animatedX.setValue(defaultX);
        this.animatedY.setValue(defaultY);
    }

    public static PositionSetting of(Module module, String name, float defaultX, float defaultY) {
        return new PositionSetting(module, name, defaultX, defaultY);
    }

    public void setPosition(float x, float y) {
        this.x = this.clamp(x, this.minX, this.maxX);
        this.y = this.clamp(y, this.minY, this.maxY);
        this.animatedX.update(this.x);
        this.animatedY.update(this.y);
    }

    public void reset() {
        this.setPosition(this.defaultX, this.defaultY);
    }

    public PositionSetting hideIf(BooleanSupplier condition) {
        return this;
    }

    public void render(UIContext context, float x, float y, float width, float height) {
        int i;
        this.hoverAnimation.update(false);
        this.dragAnimation.update(false);
        this.animatedX.update(this.x);
        this.animatedY.update(this.y);
        float controlSize = 80.0f;
        float gridSize = 70.0f;
        float circleRadius = 6.0f;
        Font font = Fonts.REGULAR.getFont(8.0f);
        context.drawText(font, this.getName(), x + 8.0f, y + 4.0f, Colors.getTextColor());
        float controlX = x + width - controlSize - 8.0f;
        float controlY = y + 20.0f;
        ColorRGBA bgColor = new ColorRGBA(32.0f, 32.0f, 32.0f, 128.0f);
        ColorRGBA outlineColor = Colors.ACCENT.withAlpha((int)(Colors.ACCENT.getAlpha() * 0.3f * this.hoverAnimation.getValue()));
        context.drawRoundedRect(controlX, controlY, controlSize, controlSize, BorderRadius.all(4.0f), bgColor);
        if (this.hoverAnimation.getValue() > 0.0f) {
            DrawUtility.drawRoundedBorder(context.method_51448(), controlX, controlY, controlSize, controlSize, 0.5f, BorderRadius.all(4.0f), outlineColor);
        }
        float gridStartX = controlX + (controlSize - gridSize) / 2.0f;
        float gridStartY = controlY + (controlSize - gridSize) / 2.0f;
        ColorRGBA gridColor = new ColorRGBA(64.0f, 64.0f, 64.0f, 77.0f);
        for (i = 0; i <= 4; ++i) {
            float lineX = gridStartX + gridSize / 4.0f * (float)i;
            context.drawRect(lineX, gridStartY, 0.5f, gridSize, gridColor);
        }
        for (i = 0; i <= 4; ++i) {
            float lineY = gridStartY + gridSize / 4.0f * (float)i;
            context.drawRect(gridStartX, lineY, gridSize, 0.5f, gridColor);
        }
        float centerX = gridStartX + gridSize / 2.0f;
        float centerY = gridStartY + gridSize / 2.0f;
        ColorRGBA crossColor = new ColorRGBA(200.0f, 200.0f, 200.0f, 179.0f);
        context.drawRect(centerX - 3.0f, centerY - 0.5f, 6.0f, 1.0f, crossColor);
        context.drawRect(centerX - 0.5f, centerY - 3.0f, 1.0f, 6.0f, crossColor);
        context.drawText(Fonts.REGULAR.getFont(6.0f), "0", centerX + 5.0f, centerY - 2.0f, new ColorRGBA(200.0f, 200.0f, 200.0f, 153.0f));
        float normalizedX = (this.animatedX.getValue() - this.minX) / (this.maxX - this.minX);
        float normalizedY = (this.animatedY.getValue() - this.minY) / (this.maxY - this.minY);
        float circleX = gridStartX + normalizedX * gridSize;
        float circleY = gridStartY + (1.0f - normalizedY) * gridSize;
        ColorRGBA lineColor = new ColorRGBA(96.0f, 96.0f, 96.0f, 102.0f);
        context.drawRect(centerX, centerY, circleX - centerX, 0.5f, lineColor);
        context.drawRect(circleX, centerY, 0.5f, circleY - centerY, lineColor);
        float currentRadius = circleRadius + this.dragAnimation.getValue() * 2.0f;
        ColorRGBA circleColor = Colors.ACCENT.withAlpha((int)(Colors.ACCENT.getAlpha() * (0.7f + 0.3f * this.dragAnimation.getValue())));
        context.drawRoundedRect(circleX - currentRadius, circleY - currentRadius, currentRadius * 2.0f, currentRadius * 2.0f, BorderRadius.all(currentRadius), circleColor);
        DrawUtility.drawRoundedBorder(context.method_51448(), circleX - currentRadius + 0.5f, circleY - currentRadius + 0.5f, currentRadius * 2.0f - 1.0f, currentRadius * 2.0f - 1.0f, 1.0f, BorderRadius.all(currentRadius - 0.5f), Colors.ACCENT);
        String valueText = String.format("X: %.2f Y: %.2f", Float.valueOf(x), Float.valueOf(y));
        float textWidth = Fonts.REGULAR.getFont(6.0f).width(valueText);
        context.drawText(Fonts.REGULAR.getFont(6.0f), valueText, controlX + (controlSize - textWidth) / 2.0f, controlY + controlSize + 4.0f, Colors.getTextColor().withAlpha(179.0f));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.dragging && button == 0) {
            this.dragging = false;
            this.dragAnimation.update(0.0f);
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging) {
            this.updatePositionFromMouse(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public void mouseMoved(double mouseX, double mouseY) {
    }

    private void updatePositionFromMouse(double mouseX, double mouseY) {
    }

    private float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    @Override
    public JsonElement save() {
        JsonObject positionObject = new JsonObject();
        positionObject.addProperty("x", (Number)Float.valueOf(this.x));
        positionObject.addProperty("y", (Number)Float.valueOf(this.y));
        return positionObject;
    }

    @Override
    public void load(JsonElement element) {
        JsonObject positionObject;
        if (element.isJsonObject() && (positionObject = element.getAsJsonObject()).has("x") && positionObject.has("y")) {
            this.x = positionObject.get("x").getAsFloat();
            this.y = positionObject.get("y").getAsFloat();
            this.animatedX.setValue(this.x);
            this.animatedY.setValue(this.y);
        }
    }

    @Override
    public void register(SettingsContainer container) {
        container.getSettings().add(this);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }
}

